/* ...............................................................

	WindowColors
	Copyright 1997-8 Steve Klingsporn <moofie@pobox.com>
	Based on WindowShade by Marco Nelissen <marcone@xs4all.nl>
	
		File:	WindowColors.h
	
	Contains:	Part of the WindowColors API implementation.
				Contains all sorts of stuff.  Include it and
				WindowColors.cpp in your project to use the
				API.
	
	   Notes:	Build-specific stuff in here.
	   
   ............................................................... */

#ifndef _WINDOW_COLORS_H
#define _WINDOW_COLORS_H

#ifndef _SUPPORT_DEFS_H
#include <SupportDefs.h>
#endif

/* ...............................................................
	Constants
   ............................................................... */

const int32		COOL_MAJOR_VERSION = 1;
const int32		COOL_MIDDLE_VERSION = 2;
const int32		COOL_MINOR_VERSION = 0;

enum
{
	WINDOW_COLORS_CHANGED	=	'_wCH'
};
   
const BRect WINDOW_BITMAP_FRAME = BRect(0, 0, 13, 13);

/* ...............................................................
	window_color_set enumeration
	Used by get_window_colors to specify the active window colors
	or the default ones.
   ............................................................... */

typedef enum
{
	ACTIVE_ONES,
	DEFAULT_ONES
} set;


/* ...............................................................
	window_color enumeration
	
	You specify a window_color with the WindowColors API.  The
	position of one of these names in the enumeration is the index
	into the window_colors array (below).  The window_colors array
	contains the correct offset into the app_server for the
	specified window color.
   ............................................................... */

typedef enum 
{
	ACTIVE_TAB_HILITE_COLOR,
	ACTIVE_TAB_BASE_COLOR,
	ACTIVE_TAB_SHADOW_COLOR,
	
	INACTIVE_TAB_HILITE_COLOR,
	INACTIVE_TAB_BASE_COLOR,
	INACTIVE_TAB_SHADOW_COLOR,
	
	MINIMIZED_TAB_HILITE_COLOR,
	MINIMIZED_TAB_BASE_COLOR,
	MINIMIZED_TAB_SHADOW_COLOR,
	
	ACTIVE_FRAME_HILITE_COLOR,	
	ACTIVE_FRAME_BASE_COLOR,
	ACTIVE_FRAME_SHADOW_COLOR,
	
	INACTIVE_FRAME_HILITE_COLOR,
	INACTIVE_FRAME_BASE_COLOR,
	INACTIVE_FRAME_SHADOW_COLOR,
	
	BORDER_COLOR,
	BORDER_SHADOW_COLOR,
	
	ACTIVE_MODAL_FRAME_HILITE_COLOR,
	ACTIVE_MODAL_FRAME_BASE_COLOR,
	ACTIVE_MODAL_FRAME_SHADOW_COLOR,	
	
	INACTIVE_MODAL_FRAME_HILITE_COLOR,
	INACTIVE_MODAL_FRAME_BASE_COLOR,
	INACTIVE_MODAL_FRAME_SHADOW_COLOR,

	RESIZE_CORNER_COLOR,
	RESIZE_CORNER_HILITE_COLOR
} window_color;
					   
/* ...............................................................
	Window bitmap enumeration
	Same story as above, with window_color vs. window_colors.
   ............................................................... */

typedef enum
{
	CLOSE_BOX_OFF_BITMAP,
	CLOSE_BOX_ON_BITMAP,
	ZOOM_BOX_OFF_BITMAP,
	ZOOM_BOX_ON_BITMAP,
	MINIMIZED_CLOSE_BOX_OFF_BITMAP,
	MINIMIZED_CLOSE_BOX_ON_BITMAP,
	RESIZE_CORNER_BITMAP
} window_bitmap;

/* ...............................................................
	The WindowColors API
	These are the functions you can call to utilize window colors.
   ............................................................... */

/* Initializes the WindowColors API */
status_t		init_window_colors();

/* Shuts down the WindowColors API */
void			shut_down_window_colors();

/* Verifies the version of the app_server */
status_t		check_app_server_version();

/* Returns the color associated with the given window_color */
rgb_color 		get_window_color(window_color which);

/* Sets the specified window_color to the specified color, and
   optionally refreshes the screen */
void	 		set_window_color(window_color which, rgb_color color,
								 bool refresh = false);

/* When passed a pointer to an array of rgb_color[NUM_WINDOW_COLORS],
   and which set, ACTIVE_WINDOW_COLORS or DEFAULT_WINDOW_COLORS,
   it fills the array with the requested values */
void			get_window_colors(rgb_color *first,
								  set ones);
								  
/* When passed a pointer to an array of rgb_color[NUM_WINDOW_COLORS],
   it sets all of the active window colors, optionally refreshing */
void			set_window_colors(rgb_color *first,
								  bool refresh = false);
								 
/* Gets the specified window_bitmap */
void			get_window_bitmap(BBitmap *bitmap,
								  window_bitmap which,
								  set ones = ACTIVE_ONES);

/* Sets the specified window_bitmap */
void			set_window_bitmap(BBitmap *bitmap, 
								  window_bitmap which);

/* Colors the bitmap with the specified template and
   base color */								  
void			color_window_bitmap(BBitmap *bitmap,
									window_bitmap which,
									rgb_color base_color);
								
/* Refreshes all of the windows on the screen */	
void			refresh_windows();

/* ...............................................................
	Color utility functions
	
	multiply_color					Multiplies the specified color
									by the specified float factor.
									
	determine_hilite_color			Given a BASE window_color and
									its value (in the model or in
									reality), a proper hilite color
									for the base color is returned.
	
	determine_shadow_color			Given a BASE window_color and
									its value (in the model or in
									reality), a proper shadow color
									for the base color is returned.
									
	index_for_color					Returns the index for the
									closest match to the specified
									color in the system's 8-bit 
									color table.
   ............................................................... */
   
rgb_color		multiply_color(rgb_color color, float factor);
rgb_color		determine_hilite_color(window_color which, 
									   rgb_color base);
rgb_color		determine_shadow_color(window_color which, 
									   rgb_color base);
uint8			index_for_color(rgb_color color);
bool			compare_colors(rgb_color color1, rgb_color color2);

/* ...............................................................
	PRIVATE -- This stuff is only valid for BeOS PR2
   ............................................................... */
  
/* ...............................................................
	window_colors array
	
	This array contains the offsets for each of the window_color
	names above into the app_server's "app_server_seg1" area.
	The hack works simply by copying a new rgb_color to one of
	these offsets in a cloned copy of the app_server's area.
	
	NOTE: These offsets only apply to BeOS PR2, and this whole
	mechanism will change in a future version of WindowColors
	(hopefully, WindowColors will go away in favor of a Be-
	delivered solution).  Don't rely on these offsets.
   ............................................................... */

const uint8 NUM_WINDOW_COLORS = 25;
const int32 WINDOW_COLORS[NUM_WINDOW_COLORS] =
{
	/* ACTIVE_TAB_HILITE_COLOR				*/	0x10220,
	/* ACTIVE_TAB_BASE_COLOR				*/	0x10224,
	/* ACTIVE_TAB_SHADOW_COLOR				*/	0x10228,
				
	/* INACTIVE_TAB_HILITE_COLOR 			*/	0x10214,
	/* INACTIVE_TAB_BASE_COLOR				*/	0x10218,
	/* INACTIVE_TAB_SHADOW_COLOR			*/	0x1021c,
	
	/* MINIMIZED_TAB_HILITE_COLOR			*/	0x10268,
	/* MINIMIZED_TAB_BASE_COLOR				*/	0x1026c,
	/* MINIMIZED_TAB_SHADOW_COLOR			*/	0x10270,

	/* ACTIVE_FRAME_HILITE_COLOR			*/	0x10208,
	/* ACTIVE_FRAME_BASE_COLOR				*/	0x1020c,
	/* ACTIVE_FRAME_SHADOW_COLOR			*/	0x10210,
	
	/* INACTIVE_FRAME_HILITE_COLOR			*/	0x101fc,
	/* INACTIVE_FRAME_BASE_COLOR			*/	0x10200,
	/* INACTIVE_FRAME_SHADOW_COLOR			*/	0x10204,
	
	/* BORDER_COLOR							*/	0x01284,
	/* BORDER_SHADOW_COLOR					*/	0x01288,
	
	/* ACTIVE_MODAL_FRAME_HILITE_COLOR		*/	0x10238,
	/* ACTIVE_MODAL_FRAME_HILITE_COLOR		*/	0x1023c,
	/* ACTIVE_MODAL_FRAME_HILITE_COLOR		*/	0x10240,
	
	/* INACTIVE_MODAL_FRAME_HILITE_COLOR	*/	0x1022c,
	/* INACTIVE_MODAL_FRAME_BASE_COLOR		*/	0x10230,
	/* INACTIVE_MODAL_FRAME_SHADOW_COLOR	*/	0x10234,

	/* RESIZE_CORNER_COLOR					*/	0x00df4,
	/* RESIZE_CORNER_HILITE_COLOR			*/	0x00dec
};

/* ...............................................................
	Default window colors
	These are the default window_color values for BeOS PR2.
   ............................................................... */
   
const rgb_color		DEFAULT_WINDOW_COLORS[NUM_WINDOW_COLORS] =
					{
						{ 255, 255, 102, 255 },
						{ 255, 203,   0, 255 },
						{ 255, 152,   0, 255 },
						{ 255, 255, 255, 255 },
						{ 232, 232, 232, 255 },
						{ 216, 216, 216, 255 },
						{ 203, 255, 255, 255 },
						{ 102, 203, 203, 255 },
						{  51, 152, 152, 255 },
						{ 255, 255, 255, 255 },
						{ 216, 216, 216, 255 },
						{ 184, 184, 184, 255 },
						{ 255, 255, 255, 255 },
						{ 232, 232, 232, 255 },
						{ 216, 216, 216, 255 },
						{ 152, 152, 152, 255 },
						{  96,  96,  96, 255 },
						{ 255, 255, 255, 255 },
						{ 216, 216, 216, 255 },
						{ 184, 184, 184, 255 },
						{ 255, 255, 255, 255 },
						{ 232, 232, 232, 255 },
						{ 216, 216, 216, 255 },
						{ 232, 232, 232, 255 },
						{ 152, 152, 152, 255 }					
					};

/* Window colors bitmap stuff */

const uint8 NUM_WINDOW_BITMAPS = 7;
const int32 window_bitmaps[NUM_WINDOW_BITMAPS] =
{
	/* CLOSE_BOX_OFF_BITMAP 			*/	0x10274,
	/* CLOSE_BOX_ON_BITMAP 				*/	0x10354,
	/* ZOOM_BOX_OFF_BITMAP 				*/	0x10434,
	/* ZOOM_BOX_ON_BITMAP 				*/	0x10514,
	/* MINIMIZED_CLOSE_BOX_OFF_BITMAP 	*/	0x107f4,
	/* MINIMIZED_CLOSE_BOX_ON_BITMAP 	*/	0x108f4,
	/* RESIZE_CORNER_BITMAP 			*/	0x0ad3c
};

/* ...............................................................
	Default window bitmaps
	Yanked from the PR2 app_server to test the API and as a
	somewhat crude but effective mechanism for reverting to
	exact defaults and coloring bitmaps.
   ............................................................... */

const uchar DEFAULT_WINDOW_BITMAPS[NUM_WINDOW_BITMAPS][224] =
{
	/* CLOSE_BOX_OFF_BITMAP (Original) */
	{
		0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 
		0x98, 0x98, 0x98, 0x98, 0x3f, 0x3f, 0x98, 0xfc, 0xfc, 0xfc, 
		0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 
		0x3f, 0x3f, 0x98, 0xfc, 0xfc, 0xe5, 0xfc, 0xe5, 0xe5, 0xe5, 
		0xe5, 0xe5, 0xe5, 0xf9, 0x98, 0xfc, 0x3f, 0x3f, 0x98, 0xfc, 
		0xe5, 0xfc, 0xe5, 0xe5, 0xe5, 0xe5, 0xf9, 0xe5, 0xf9, 0xe5,
		0x98, 0xfc, 0x3f, 0x3f, 0x98, 0xfc, 0xfc, 0xe5, 0xe5, 0xe5, 
		0xe5, 0xf9, 0xe5, 0xf9, 0xe5, 0xf9, 0x98, 0xfc, 0x3f, 0x3f, 
		0x98, 0xfc, 0xe5, 0xe5, 0xe5, 0xe5, 0xf9, 0xe5, 0xf9, 0xf9, 
		0xf9, 0xf9, 0x98, 0xfc, 0x3f, 0x3f, 0x98, 0xfc, 0xe5, 0xe5, 
		0xe5, 0xf9, 0xe5, 0xf9, 0xf9, 0xf9, 0xf9, 0xbd, 0x98, 0xfc, 
		0x3f, 0x3f, 0x98, 0xfc, 0xe5, 0xe5, 0xf9, 0xe5, 0xf9, 0xf9, 
		0xf9, 0xbd, 0xbd, 0xbd, 0x98, 0xfc, 0x3f, 0x3f, 0x98, 0xfc,
		0xe5, 0xf9, 0xe5, 0xf9, 0xf9, 0xf9, 0xbd, 0xf9, 0xbd, 0xbd, 
		0x98, 0xfc, 0x3f, 0x3f, 0x98, 0xfc, 0xe5, 0xe5, 0xf9, 0xf9, 
		0xf9, 0xbd, 0xf9, 0xbd, 0xbd, 0xbd, 0x98, 0xfc, 0x3f, 0x3f, 
		0x98, 0xfc, 0xe5, 0xf9, 0xe5, 0xf9, 0xf9, 0xbd, 0xbd, 0xbd, 
		0xbd, 0xbd, 0x98, 0xfc, 0x3f, 0x3f, 0x98, 0xfc, 0xf9, 0xe5, 
		0xf9, 0xf9, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0x98, 0xfc, 
		0x3f, 0x3f, 0x98, 0xfc, 0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 
		0x98, 0x98, 0x98, 0x98, 0x98, 0xfc, 0x3f, 0x3f, 0x98, 0xfc, 
		0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 
		0xfc, 0xfc, 0x3f, 0x3f
	},
	/* CLOSE_BOX_ON_BITMAP (Original) */
	{
		0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0x98,
		0x98, 0x98, 0x98, 0x98, 0x3f, 0x3f, 0x98, 0x98, 0x98, 0x98,
		0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0xfc,
		0x3f, 0x3f, 0x98, 0x98, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd,
		0xf9, 0xf9, 0xe5, 0xf9, 0xfc, 0xfc, 0x3f, 0x3f, 0x98, 0x98,
		0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xf9, 0xf9, 0xe5, 0xf9, 0xe5,
		0xfc, 0xfc, 0x3f, 0x3f, 0x98, 0x98, 0xbd, 0xbd, 0xbd, 0xf9,
		0xbd, 0xf9, 0xf9, 0xf9, 0xe5, 0xf9, 0xfc, 0xfc, 0x3f, 0x3f,
		0x98, 0x98, 0xbd, 0xbd, 0xf9, 0xbd, 0xf9, 0xf9, 0xf9, 0xe5,
		0xf9, 0xf9, 0xfc, 0xfc, 0x3f, 0x3f, 0x98, 0x98, 0xbd, 0xbd,
		0xbd, 0xf9, 0xf9, 0xf9, 0xe5, 0xf9, 0xe5, 0xe5, 0xfc, 0xfc,
		0x3f, 0x3f, 0x98, 0x98, 0xbd, 0xf9, 0xf9, 0xf9, 0xf9, 0xe5,
		0xf9, 0xe5, 0xe5, 0xe5, 0xfc, 0xfc, 0x3f, 0x3f, 0x98, 0x98,
		0xf9, 0xf9, 0xf9, 0xf9, 0xe5, 0xf9, 0xe5, 0xe5, 0xe5, 0xe5,
		0xfc, 0xfc, 0x3f, 0x3f, 0x98, 0x98, 0xf9, 0xe5, 0xf9, 0xe5,
		0xf9, 0xe5, 0xe5, 0xe5, 0xe5, 0xfc, 0xfc, 0xfc, 0x3f, 0x3f,
		0x98, 0x98, 0xe5, 0xf9, 0xe5, 0xf9, 0xe5, 0xe5, 0xe5, 0xe5,
		0xfc, 0xe5, 0xfc, 0xfc, 0x3f, 0x3f, 0x98, 0x98, 0xf9, 0xe5,
		0xe5, 0xe5, 0xe5, 0xe5, 0xe5, 0xfc, 0xe5, 0xfc, 0xfc, 0xfc,
		0x3f, 0x3f, 0x98, 0x98, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,
		0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0x3f, 0x3f, 0x98, 0xfc,
		0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,
		0xfc, 0xfc, 0x3f, 0x3f
	},
	/* ZOOM_BOX_OFF_BITMAP (Original) */
	{
		0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0xf9, 0xf9,
		0xf9, 0xf9, 0xf9, 0xf9, 0x3f, 0x3f, 0x5d, 0xfc, 0xfc, 0xfc,
		0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9,
		0x3f, 0x3f, 0x5d, 0xfc, 0xfc, 0xe5, 0xe5, 0xf9, 0xf9, 0x5d,
		0xfc, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0x1e, 0x3f, 0x5d, 0xfc,
		0xe5, 0xe5, 0xf9, 0xe5, 0xf9, 0x5d, 0xfc, 0x5d, 0x5d, 0x5d,
		0x5d, 0x5d, 0x3f, 0x3f, 0x5d, 0xfc, 0xe5, 0xf9, 0xe5, 0xf9,
		0xf9, 0x5d, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0x3f, 0x3f,
		0x5d, 0xfc, 0xf9, 0xe5, 0xf9, 0xf9, 0xbd, 0x5d, 0xfc, 0xe5,
		0xe5, 0xe5, 0x5d, 0xfc, 0x3f, 0x3f, 0x5d, 0xfc, 0xf9, 0xf9,
		0xbd, 0xbd, 0xbd, 0x5d, 0xfc, 0xe5, 0xe5, 0xbd, 0x5d, 0xfc,
		0x3f, 0x3f, 0x5d, 0xfc, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d,
		0xfc, 0xe5, 0xf9, 0xbd, 0x5d, 0xfc, 0x3f, 0x3f, 0xf9, 0xfc,
		0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xf9, 0xe5, 0xbd,
		0x5d, 0xfc, 0x3f, 0x3f, 0xf9, 0xf9, 0xf9, 0x5d, 0xfc, 0xe5,
		0xe5, 0xe5, 0xf9, 0xe5, 0xf9, 0xbd, 0x5d, 0xfc, 0x3f, 0x3f,
		0xf9, 0xf9, 0xf9, 0x5d, 0xfc, 0xe5, 0xe5, 0xf9, 0xe5, 0xf9,
		0xf9, 0xbd, 0x5d, 0xfc, 0x3f, 0x3f, 0xf9, 0xf9, 0xf9, 0x5d,
		0xfc, 0xe5, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0x5d, 0xfc,
		0x3f, 0x3f, 0xf9, 0xf9, 0xf9, 0x5d, 0xfc, 0x5d, 0x5d, 0x5d,
		0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0xfc, 0x3f, 0x3f, 0xf9, 0xf9,
		0xf9, 0x5d, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,
		0xfc, 0xfc, 0x3f, 0x3f
	},
	/* ZOOM_BOX_ON_BITMAP (Original) */
	{
		0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0xf9,
		0xf9, 0xf9, 0xf9, 0xf9, 0x3f, 0x3f, 0x98, 0x98, 0x98, 0x98,
		0x98, 0x98, 0x98, 0x98, 0xfc, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9,
		0x3f, 0x3f, 0x98, 0x98, 0xbd, 0xbd, 0xbd, 0xf9, 0xf9, 0xfc,
		0xfc, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0x3f, 0x3f, 0x98, 0x98,
		0xbd, 0xf9, 0xf9, 0xf9, 0xe5, 0xfc, 0xfc, 0x98, 0x98, 0x98,
		0x98, 0x98, 0x3f, 0x3f, 0x98, 0x98, 0xbd, 0xf9, 0xf9, 0xe5,
		0xe5, 0xfc, 0xfc, 0x98, 0x98, 0x98, 0x98, 0xfc, 0x3f, 0x3f,
		0x98, 0x98, 0xf9, 0xf9, 0xe5, 0xe5, 0xe5, 0xfc, 0xfc, 0xbd,
		0xbd, 0xe5, 0xfc, 0xfc, 0x3f, 0x3f, 0x98, 0x98, 0xf9, 0xe5,
		0xe5, 0xe5, 0xe5, 0xfc, 0xfc, 0xf9, 0xe5, 0xe5, 0xfc, 0xfc,
		0x3f, 0x3f, 0x98, 0x98, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,
		0xfc, 0xe5, 0xf9, 0xe5, 0xfc, 0xfc, 0x3f, 0x3f, 0x98, 0xfc,
		0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xf9, 0xe5, 0xe5,
		0xfc, 0xfc, 0x3f, 0x3f, 0xf9, 0xf9, 0xf9, 0x98, 0x98, 0xbd,
		0xf9, 0xe5, 0xf9, 0xe5, 0xf9, 0xe5, 0xfc, 0xfc, 0x3f, 0x3f,
		0xf9, 0xf9, 0xf9, 0x98, 0x98, 0xbd, 0xe5, 0xf9, 0xe5, 0xf9,
		0xe5, 0xe5, 0xfc, 0xfc, 0x3f, 0x3f, 0xf9, 0xf9, 0xf9, 0x98,
		0x98, 0xe5, 0xe5, 0xe5, 0xe5, 0xe5, 0xe5, 0xe5, 0xfc, 0xfc,
		0x3f, 0x3f, 0xf9, 0xf9, 0xf9, 0x98, 0x98, 0xfc, 0xfc, 0xfc,
		0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0x3f, 0x3f, 0xf9, 0xf9,
		0xf9, 0x98, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,
		0xfc, 0xfc, 0x3f, 0x3f
	},
	/* MINIMIZED_CLOSE_BOX_OFF (Original) */
	{
		0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94,
		0x94, 0x94, 0x94, 0x94, 0x6d, 0x6d, 0x94, 0x40, 0x40, 0x40,
		0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
		0x6d, 0x6d, 0x94, 0x40, 0x3f, 0x67, 0x40, 0x6d, 0x40, 0x6d,
		0x40, 0x6d, 0x6d, 0x6d, 0x94, 0x40, 0x6d, 0x6d, 0x94, 0x40,
		0x67, 0x40, 0x6d, 0x40, 0x6d, 0x40, 0x6d, 0x6d, 0x6d, 0x6d,
		0x94, 0x40, 0x6d, 0x6d, 0x94, 0x40, 0x40, 0x6d, 0x40, 0x6d,
		0x40, 0x6d, 0x6d, 0x6d, 0x6d, 0x94, 0x94, 0x40, 0x6d, 0x6d,
		0x94, 0x40, 0x6d, 0x40, 0x6d, 0x40, 0x6d, 0x6d, 0x6d, 0x6d,
		0x94, 0x6d, 0x94, 0x40, 0x6d, 0x6d, 0x94, 0x40, 0x40, 0x6d,
		0x40, 0x6d, 0x6d, 0x6d, 0x6d, 0x94, 0x6d, 0x94, 0x94, 0x40,
		0x6d, 0x6d, 0x94, 0x40, 0x6d, 0x40, 0x6d, 0x6d, 0x6d, 0x6d,
		0x94, 0x6d, 0x94, 0x6d, 0x94, 0x40, 0x6d, 0x6d, 0x94, 0x40,
		0x40, 0x6d, 0x6d, 0x6d, 0x6d, 0x94, 0x6d, 0x94, 0x6d, 0x94,
		0x94, 0x40, 0x6d, 0x6d, 0x94, 0x40, 0x6d, 0x6d, 0x6d, 0x6d,
		0x94, 0x6d, 0x94, 0x6d, 0x94, 0x6d, 0x94, 0x40, 0x6d, 0x6d,
		0x94, 0x40, 0x6d, 0x6d, 0x6d, 0x94, 0x6d, 0x94, 0x6d, 0x94,
		0x6d, 0x94, 0x94, 0x40, 0x6d, 0x6d, 0x94, 0x40, 0x6d, 0x6d,
		0x94, 0x6d, 0x94, 0x6d, 0x94, 0x6d, 0x94, 0x6d, 0x94, 0x40,
		0x6d, 0x6d, 0x94, 0x40, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94,
		0x94, 0x94, 0x94, 0x94, 0x94, 0x40, 0x6d, 0x6d, 0x94, 0x40,
		0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
		0x40, 0x40, 0x6d, 0x6d
	},
	/* MINIMIZED_CLOSE_BOX_ON (Original) */
	{
		0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94,
		0x94, 0x94, 0x94, 0x94, 0x6d, 0x6d, 0x94, 0x94, 0x94, 0x94,
		0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x40, 0x40,
		0x6d, 0x6d, 0x94, 0x94, 0x6d, 0x94, 0x6d, 0x94, 0x6d, 0x94,
		0x6d, 0x94, 0x6d, 0x6d, 0x40, 0x40, 0x6d, 0x6d, 0x94, 0x94,
		0x94, 0x6d, 0x94, 0x6d, 0x94, 0x6d, 0x94, 0x6d, 0x6d, 0x6d,
		0x40, 0x40, 0x6d, 0x6d, 0x94, 0x94, 0x6d, 0x94, 0x6d, 0x94,
		0x6d, 0x94, 0x6d, 0x6d, 0x6d, 0x6d, 0x40, 0x40, 0x6d, 0x6d,
		0x94, 0x94, 0x94, 0x6d, 0x94, 0x6d, 0x94, 0x6d, 0x6d, 0x6d,
		0x6d, 0x40, 0x40, 0x40, 0x6d, 0x6d, 0x94, 0x94, 0x6d, 0x94,
		0x6d, 0x94, 0x6d, 0x6d, 0x6d, 0x6d, 0x40, 0x6d, 0x40, 0x40,
		0x6d, 0x6d, 0x94, 0x94, 0x94, 0x6d, 0x94, 0x6d, 0x6d, 0x6d,
		0x6d, 0x40, 0x6d, 0x40, 0x40, 0x40, 0x6d, 0x6d, 0x94, 0x94,
		0x6d, 0x94, 0x6d, 0x6d, 0x6d, 0x6d, 0x40, 0x6d, 0x40, 0x6d,
		0x40, 0x40, 0x6d, 0x6d, 0x94, 0x94, 0x94, 0x6d, 0x6d, 0x6d,
		0x6d, 0x40, 0x6d, 0x40, 0x6d, 0x40, 0x40, 0x40, 0x6d, 0x6d,
		0x94, 0x94, 0x6d, 0x6d, 0x6d, 0x6d, 0x40, 0x6d, 0x40, 0x6d,
		0x40, 0x67, 0x40, 0x40, 0x6d, 0x6d, 0x94, 0x94, 0x6d, 0x6d,
		0x6d, 0x40, 0x6d, 0x40, 0x6d, 0x40, 0x67, 0x3f, 0x40, 0x40,
		0x6d, 0x6d, 0x94, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
		0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x6d, 0x6d, 0x94, 0x40,
		0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
		0x40, 0x40, 0x6d, 0x6d
	},
	/* RESIZE_CORNER_BITMAP (Original) */
	{
		0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b,
		0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x17, 0x1b, 0x1b, 0x1b, 0x1b,
		0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b,
		0x1b, 0x17, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b,
		0x1b, 0x1b, 0x1b, 0x0c, 0x1b, 0x1b, 0x1b, 0x17, 0x1b, 0x1b,
		0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b,
		0x3f, 0x1b, 0x1b, 0x17, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b,
		0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x17,
		0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0c, 0x1b,
		0x1b, 0x0c, 0x1b, 0x1b, 0x1b, 0x17, 0x1b, 0x1b, 0x1b, 0x1b,
		0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x3f, 0x1b, 0x1b, 0x3f, 0x1b,
		0x1b, 0x17, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b,
		0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x17, 0x1b, 0x1b,
		0x1b, 0x1b, 0x1b, 0x0c, 0x1b, 0x1b, 0x0c, 0x1b, 0x1b, 0x0c,
		0x1b, 0x1b, 0x1b, 0x17, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b,
		0x3f, 0x1b, 0x1b, 0x3f, 0x1b, 0x1b, 0x3f, 0x1b, 0x1b, 0x17,
		0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b,
		0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x17, 0x1b, 0x1b, 0x0c, 0x1b,
		0x1b, 0x0c, 0x1b, 0x1b, 0x0c, 0x1b, 0x1b, 0x0c, 0x1b, 0x1b,
		0x1b, 0x17, 0x1b, 0x1b, 0x1b, 0x3f, 0x1b, 0x1b, 0x3f, 0x1b,
		0x1b, 0x3f, 0x1b, 0x1b, 0x3f, 0x1b, 0x1b, 0x17, 0x1b, 0x1b,
		0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b,
		0x1b, 0x1b, 0x1b, 0x17
	}
};

#endif